/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash.command;

import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.plugin.hash.command.HashCommands;
import java.io.File;

final class HashParameters {
    public static final String PARAM_HELP = "-help";
    private static final String PARAM_INPUT = "-i";
    private static final String PARAM_OUTPUT = "-o";
    private static final String PARAM_XML = "-xml";
    private static final String PARAM_GUI = "-gui";
    private static final String PARAM_HASH_FORMAT = "-hformat";
    private static final String PARAM_HASH_ALGO = "-halgorithm";
    private static final String PARAM_RECURSIVE = "-r";
    private static final String PARAM_DIRECTORY = "-d";
    public static final String FORMAT_HASH_FILE_HEX = "hex";
    public static final String FORMAT_HASH_FILE_BASE64 = "b64";
    public static final String FORMAT_HASH_FILE_BIN = "bin";
    public static final String FORMAT_HASH_DIR_PLAIN = "txt";
    public static final String FORMAT_HASH_DIR_XML = "xml";
    public static final String DEFAULT_FORMAT_FILE_HASH = "hex";
    public static final String DEFAULT_FORMAT_DIR_HASH = "xml";
    private static final String DEFAULT_HASH_ALGORITHM = "SHA-256";
    private File mainFile = null;
    private File inputFile = null;
    private File outputFile = null;
    private String hashFormat = null;
    private String hashAlgorithm = null;
    private boolean xml = false;
    private boolean gui = false;
    private boolean recursive = false;
    private boolean directory = false;

    public HashParameters(HashCommands hashCommands, String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        if (hashCommands.isMainFileNeeded()) {
            if (stringArray.length < 1) {
                throw new IllegalArgumentException(Messages.getString("CommandLine.120"));
            }
            this.mainFile = HashParameters.readMainFile(stringArray[n]);
            this.mainFile = new File(stringArray[n]);
            if (!this.mainFile.exists()) {
                throw new IllegalArgumentException(Messages.getString("CommandLine.121", stringArray[n]));
            }
            if (!this.mainFile.canRead()) {
                throw new IllegalArgumentException(Messages.getString("CommandLine.122", stringArray[n]));
            }
            ++n;
        }
        while (n < stringArray.length) {
            if (PARAM_XML.equals(stringArray[n])) {
                this.xml = true;
            } else if (PARAM_GUI.equals(stringArray[n])) {
                this.gui = true;
            } else if (PARAM_RECURSIVE.equals(stringArray[n])) {
                this.recursive = true;
            } else if (PARAM_DIRECTORY.equals(stringArray[n])) {
                this.directory = true;
            } else if (PARAM_HASH_ALGO.equals(stringArray[n])) {
                if (this.hashAlgorithm != null) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.26", stringArray[n]));
                }
                this.hashAlgorithm = stringArray[n + 1];
                ++n;
            } else if (PARAM_INPUT.equals(stringArray[n])) {
                if (this.inputFile != null) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.26", stringArray[n]));
                }
                if (n >= stringArray.length - 1) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.74"));
                }
                this.inputFile = new File(stringArray[n + 1]);
                if (!this.inputFile.exists()) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.0", stringArray[n + 1]));
                }
                if (!this.inputFile.canRead()) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.1", stringArray[n + 1]));
                }
                ++n;
            } else if (PARAM_HASH_FORMAT.equals(stringArray[n])) {
                if (this.hashFormat != null) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.26", stringArray[n]));
                }
                this.hashFormat = stringArray[n + 1].toLowerCase();
                if (!(this.hashFormat.equals("hex") || this.hashFormat.equals(FORMAT_HASH_FILE_BIN) || this.hashFormat.equals(FORMAT_HASH_FILE_BASE64) || this.hashFormat.equals("xml") || this.hashFormat.equals(FORMAT_HASH_DIR_PLAIN))) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.89", stringArray[n + 1]));
                }
                ++n;
            } else if (PARAM_OUTPUT.equals(stringArray[n])) {
                if (this.outputFile != null) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.26", stringArray[n]));
                }
                if (n >= stringArray.length - 1) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.75"));
                }
                this.outputFile = new File(stringArray[n + 1]);
                String string = this.outputFile.getParent();
                if (string != null && !new File(string).canWrite()) {
                    throw new IllegalArgumentException(Messages.getString("CommandLine.3", stringArray[n + 1]));
                }
                ++n;
            } else if (n == 0) {
                this.mainFile = HashParameters.readMainFile(stringArray[n]);
            } else {
                throw new IllegalArgumentException(Messages.getString("CommandLine.25", stringArray[n]));
            }
            ++n;
        }
    }

    private static File readMainFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(Messages.getString("CommandLine.121", string));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(Messages.getString("CommandLine.122", string));
        }
        return file;
    }

    public File getMainFile() {
        return this.mainFile;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public String getHashFormat() {
        return this.hashFormat;
    }

    String getHashDirectoryFormat() throws IllegalArgumentException {
        String string;
        if (this.hashFormat == null) {
            string = "xml";
        } else if (this.hashFormat.equals("xml") || this.hashFormat.equals(FORMAT_HASH_DIR_PLAIN)) {
            string = this.hashFormat;
        } else {
            throw new IllegalArgumentException(Messages.getString("CommandLine.90", this.hashFormat));
        }
        return string;
    }

    String getHashFileFormat() throws IllegalArgumentException {
        String string;
        if (this.hashFormat == null) {
            string = "hex";
        } else if (this.hashFormat.equals("hex") || this.hashFormat.equals(FORMAT_HASH_FILE_BASE64) || this.hashFormat.equals(FORMAT_HASH_FILE_BIN)) {
            string = this.hashFormat;
        } else {
            throw new IllegalArgumentException(Messages.getString("CommandLine.91", this.hashFormat));
        }
        return string;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm != null ? this.hashAlgorithm : DEFAULT_HASH_ALGORITHM;
    }

    public boolean isXml() {
        return this.xml;
    }

    public boolean isGui() {
        return this.gui;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public static String buildSyntaxError(HashCommands hashCommands, String string) {
        switch (hashCommands) {
            case CHECKHASH: {
                return HashParameters.buildOperationCheckHashSyntaxError(hashCommands.getOp(), string);
            }
            case CREATEHASH: {
                return HashParameters.buildOperationCreateHashSyntaxError(hashCommands.getOp(), string);
            }
        }
        return string;
    }

    private static String buildOperationCheckHashSyntaxError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2).append("\n");
        }
        stringBuilder.append(Messages.getString("CommandLine.7")).append(":\n").append("  AutoFirma ").append(string).append(" [FICHERO] [opciones...]\t\t- ").append(Messages.getString("CommandLine.108")).append("\n").append("  AutoFirma ").append(string).append(" [DIRECTORIO] [opciones...]\t- ").append(Messages.getString("CommandLine.109")).append("\n\n").append(Messages.getString("CommandLine.114")).append(":\n").append("  ").append("FICHERO").append("\t\t(").append(Messages.getString("CommandLine.106")).append(")\n").append("  ").append("DIRECTORIO").append("\t\t(").append(Messages.getString("CommandLine.107")).append(")\n\n").append(Messages.getString("CommandLine.116")).append(":\n").append("  ").append(PARAM_GUI).append("\t\t\t(").append(Messages.getString("CommandLine.100")).append(")\n").append("  ").append(PARAM_INPUT).append(" FICHERO\t\t(").append(Messages.getString("CommandLine.67")).append(")\n\n").append(Messages.getString("CommandLine.117")).append(":\n").append("  ").append(PARAM_GUI).append("\t\t\t(").append(Messages.getString("CommandLine.100")).append(")\n").append("  ").append(PARAM_INPUT).append(" FICHERO\t\t(").append(Messages.getString("CommandLine.105")).append(")\n").append("  ").append(PARAM_OUTPUT).append(" FICHERO\t\t(").append(Messages.getString("CommandLine.97")).append(")\n");
        return stringBuilder.toString();
    }

    private static String buildOperationCreateHashSyntaxError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2).append("\n");
        }
        stringBuilder.append(Messages.getString("CommandLine.7")).append(":\n").append("  AutoFirma ").append(string).append(" FICHERO [opciones...]\t\t- ").append(Messages.getString("CommandLine.110")).append("\n").append("  AutoFirma ").append(string).append(" DIRECTORIO [opciones...]\t- ").append(Messages.getString("CommandLine.111")).append("\n\n").append(Messages.getString("CommandLine.114")).append(":\n").append("  ").append("FICHERO").append("\t\t(").append(Messages.getString("CommandLine.112")).append(")\n").append("  ").append("DIRECTORIO").append("\t\t(").append(Messages.getString("CommandLine.113")).append(")\n\n").append(Messages.getString("CommandLine.116")).append(":\n").append("  ").append(PARAM_GUI).append("\t\t\t (").append(Messages.getString("CommandLine.95")).append(")\n").append("  ").append(PARAM_OUTPUT).append(" FICHERO\t\t (").append(Messages.getString("CommandLine.118")).append(")\n").append("  ").append(PARAM_HASH_ALGO).append(" ALGORITMO\t (").append(Messages.getString("CommandLine.77")).append(")\n").append("  ").append(PARAM_HASH_FORMAT).append(" FORMATO\t (").append(Messages.getString("CommandLine.78")).append(")\n").append("  \t ").append("hex").append("\t\t (").append(Messages.getString("CommandLine.81")).append(") (").append(Messages.getString("CommandLine.79")).append(")\n").append("  \t ").append(FORMAT_HASH_FILE_BASE64).append("\t\t (").append(Messages.getString("CommandLine.82")).append(")\n").append("  \t ").append(FORMAT_HASH_FILE_BIN).append("\t\t (").append(Messages.getString("CommandLine.83")).append(")\n\n").append(Messages.getString("CommandLine.117")).append(":\n").append("  ").append(PARAM_GUI).append("\t\t\t (").append(Messages.getString("CommandLine.95")).append(")\n").append("  ").append(PARAM_OUTPUT).append(" FICHERO\t\t (").append(Messages.getString("CommandLine.96")).append(")\n").append("  ").append(PARAM_HASH_ALGO).append(" ALGORITMO\t (").append(Messages.getString("CommandLine.77")).append(")\n").append("  ").append(PARAM_HASH_FORMAT).append(" FORMATO\t (").append(Messages.getString("CommandLine.78")).append(")\n").append("  \t ").append("xml").append("\t\t (").append(Messages.getString("CommandLine.85")).append(") (").append(Messages.getString("CommandLine.79")).append(")\n").append("  \t ").append(FORMAT_HASH_DIR_PLAIN).append("\t\t (").append(Messages.getString("CommandLine.86")).append(")\n").append("  ").append(PARAM_RECURSIVE).append("\t\t (").append(Messages.getString("CommandLine.92")).append(")\n");
        return stringBuilder.toString();
    }
}

