/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash.command;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.plugin.hash.CreateHashDirDialog;
import es.gob.afirma.plugin.hash.CreateHashFileDialog;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashDocument;
import es.gob.afirma.plugin.hash.HashDocumentFactory;
import es.gob.afirma.plugin.hash.HashUIHelper;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.plugin.hash.command.HashCommands;
import es.gob.afirma.plugin.hash.command.HashParameters;
import es.gob.afirma.standalone.plugins.PluginCommandAction;
import es.gob.afirma.standalone.plugins.PluginControlledException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class CreateHashCommand
extends PluginCommandAction {
    static String COMMAND = HashCommands.CREATEHASH.getOp();

    public CreateHashCommand() {
        super(COMMAND);
    }

    public CreateHashCommand(String string) {
        super(string);
    }

    protected String process(String[] stringArray) throws IllegalArgumentException, PluginControlledException {
        if (stringArray != null && stringArray.length > 0 && "-help".equalsIgnoreCase(stringArray[0])) {
            return this.getHelpText();
        }
        String string = null;
        HashParameters hashParameters = new HashParameters(HashCommands.CREATEHASH, stringArray);
        if (hashParameters.isGui()) {
            CreateHashCommand.createHashByGui(hashParameters);
            Runtime.getRuntime().halt(0);
        } else {
            try {
                string = CreateHashCommand.createHashByCommandLine(hashParameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new PluginControlledException(exception.getMessage(), (Throwable)exception);
            }
        }
        return string;
    }

    private static void createHashByGui(HashParameters hashParameters) throws IllegalArgumentException {
        HashUIHelper.createHashUI(hashParameters.getMainFile(), hashParameters.getOutputFile(), hashParameters.getHashAlgorithm(), hashParameters.getHashFormat(), hashParameters.isRecursive());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String createHashByCommandLine(HashParameters hashParameters) throws IllegalArgumentException, IOException, AOException {
        byte[] byArray;
        Object object;
        Object object2;
        block26: {
            File file = hashParameters.getMainFile();
            if (file == null) {
                throw new IllegalArgumentException(Messages.getString("CommandLine.5"));
            }
            if (!file.exists()) {
                throw new IOException(Messages.getString("CommandLine.87", file.getAbsolutePath()));
            }
            if (!file.canRead()) {
                throw new IOException(Messages.getString("CommandLine.88", file.getAbsolutePath()));
            }
            try {
                String string;
                if (file.isDirectory()) {
                    string = hashParameters.getHashDirectoryFormat();
                    object2 = CreateHashDirDialog.calculateHashes(file, hashParameters.isRecursive(), hashParameters.getHashAlgorithm(), null);
                    object = HashDocumentFactory.getHashDocument(string);
                    ((HashDocument)object).setHashes((Map<String, byte[]>)object2);
                    ((HashDocument)object).setRecursive(hashParameters.isRecursive());
                    ((HashDocument)object).setAlgorithm(hashParameters.getHashAlgorithm());
                    ((HashDocument)object).setCharset(StandardCharsets.UTF_8);
                    try {
                        byArray = ((HashDocument)object).generate();
                        break block26;
                    }
                    catch (DocumentException documentException) {
                        throw new AOException(Messages.getString("CommandLine.93"), (Throwable)documentException);
                    }
                }
                string = hashParameters.getHashFileFormat();
                object2 = CreateHashFileDialog.calculateHash(file, hashParameters.getHashAlgorithm(), null);
                if (string.equals("b64")) {
                    byArray = Base64.encode((byte[])object2).getBytes();
                } else if (string.equals("bin")) {
                    if (hashParameters.getOutputFile() == null) throw new IllegalArgumentException(Messages.getString("CommandLine.119"));
                    byArray = object2;
                } else {
                    byArray = (AOUtil.hexify((byte[])object2, (boolean)false) + "h").getBytes();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new AOException(Messages.getString("CommandLine.94"), (Throwable)exception);
            }
        }
        if (hashParameters.getOutputFile() == null) return new String(byArray);
        try {
            object2 = new FileOutputStream(hashParameters.getOutputFile());
            object = null;
            try {
                ((OutputStream)object2).write(byArray);
                return Messages.getString("CommandLine.22");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((OutputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IOException(Messages.getString("CommandLine.21", hashParameters.getOutputFile().getAbsolutePath()), exception);
        }
    }

    public String getHelpText() {
        return HashParameters.buildSyntaxError(HashCommands.CREATEHASH, null);
    }
}

