/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash.command;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.plugin.hash.CheckHashDirDialog;
import es.gob.afirma.plugin.hash.CheckHashFileDialog;
import es.gob.afirma.plugin.hash.CorruptedDocumentException;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashReport;
import es.gob.afirma.plugin.hash.HashUIHelper;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.plugin.hash.command.HashCommands;
import es.gob.afirma.plugin.hash.command.HashParameters;
import es.gob.afirma.standalone.plugins.PluginCommandAction;
import es.gob.afirma.standalone.plugins.PluginControlledException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;

public class CheckHashCommand
extends PluginCommandAction {
    static String COMMAND = HashCommands.CHECKHASH.getOp();

    public CheckHashCommand() {
        super(COMMAND);
    }

    public CheckHashCommand(String string) {
        super(string);
    }

    protected String process(String[] stringArray) throws PluginControlledException {
        if (stringArray == null || stringArray.length == 0 || "-help".equalsIgnoreCase(stringArray[0])) {
            return this.getHelpText();
        }
        String string = null;
        HashParameters hashParameters = new HashParameters(HashCommands.CHECKHASH, stringArray);
        if (hashParameters.isGui()) {
            CheckHashCommand.checkHashByGui(hashParameters);
            Runtime.getRuntime().halt(0);
        } else {
            boolean bl;
            try {
                bl = CheckHashCommand.checkHashByCommandLine(hashParameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new PluginControlledException(exception.getMessage(), (Throwable)exception);
            }
            string = bl ? Messages.getString("CommandLine.123") : Messages.getString("CommandLine.124");
        }
        return string;
    }

    private static boolean checkHashByCommandLine(HashParameters hashParameters) throws IllegalArgumentException, IOException, AOException {
        boolean bl;
        File file = hashParameters.getMainFile();
        if (file == null) {
            throw new IllegalArgumentException(Messages.getString("CommandLine.5"));
        }
        if (!file.exists()) {
            throw new IOException(Messages.getString("CommandLine.87", file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new IOException(Messages.getString("CommandLine.88", file.getAbsolutePath()));
        }
        File file2 = hashParameters.getInputFile();
        if (file2 == null) {
            throw new IllegalArgumentException(Messages.getString("CommandLine.6"));
        }
        if (!file2.exists()) {
            throw new IOException(Messages.getString("CommandLine.98", file2.getAbsolutePath()));
        }
        if (!file2.canRead()) {
            throw new IOException(Messages.getString("CommandLine.99", file2.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            HashReport hashReport = new HashReport();
            try {
                CheckHashDirDialog.checkHash(file.toPath(), file2, hashReport);
            }
            catch (IOException iOException) {
                throw new IOException(Messages.getString("CommandLine.101"), iOException);
            }
            catch (DocumentException documentException) {
                throw new AOException(Messages.getString("CommandLine.102"), (Throwable)documentException);
            }
            catch (CorruptedDocumentException corruptedDocumentException) {
                throw new AOException(Messages.getString("CommandLine.103"), (Throwable)corruptedDocumentException);
            }
            boolean bl2 = bl = !hashReport.hasErrors();
            if (hashParameters.getOutputFile() != null) {
                byte[] byArray;
                try {
                    byArray = CheckHashDirDialog.generateXMLReport(hashReport).getBytes(hashReport.getCharset());
                }
                catch (Exception exception) {
                    throw new AOException(Messages.getString("CommandLine.104"), (Throwable)exception);
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(hashParameters.getOutputFile());){
                    ((OutputStream)fileOutputStream).write(byArray);
                }
                catch (Exception exception) {
                    throw new IOException(Messages.getString("CommandLine.21", hashParameters.getOutputFile().getAbsolutePath()), exception);
                }
            }
        } else {
            try {
                bl = CheckHashFileDialog.checkHash(file2, file, null);
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new AOException(Messages.getString("CommandLine.94"), (Throwable)exception);
            }
        }
        return bl;
    }

    private static void checkHashByGui(HashParameters hashParameters) throws IllegalArgumentException {
        File file = hashParameters.getMainFile();
        if (file == null) {
            try {
                file = hashParameters.isDirectory() ? HashUIHelper.loadDirToCheck() : HashUIHelper.loadFileToCheck();
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                return;
            }
        }
        File file2 = hashParameters.getInputFile();
        HashUIHelper.checkHashUI(file, file2);
    }

    public String getHelpText() {
        return HashParameters.buildSyntaxError(HashCommands.CHECKHASH, null);
    }
}

