/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.plugin.hash.CheckHashDirDialog;
import es.gob.afirma.plugin.hash.CorruptedDocumentException;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashDocument;
import es.gob.afirma.plugin.hash.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlHashDocument
extends HashDocument {
    @Override
    public byte[] generate() throws DocumentException {
        Object object;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new DocumentException("No se puede componer el documento XML", exception);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("entries");
        document.appendChild(element);
        Attr attr = document.createAttribute("hashAlgorithm");
        attr.setValue(this.getAlgorithm());
        element.setAttributeNode(attr);
        Attr attr2 = document.createAttribute("recursive");
        attr2.setValue(String.valueOf(this.isRecursive()));
        element.setAttributeNode(attr2);
        Map<String, byte[]> map = this.getHashes();
        Set<String> set = map.keySet();
        for (String object2 : set) {
            object = map.get(object2);
            Element element2 = document.createElement("entry");
            element.appendChild(element2);
            Attr attr3 = document.createAttribute("name");
            attr3.setValue(object2);
            element2.setAttributeNode(attr3);
            Attr attr4 = document.createAttribute("hash");
            attr4.setValue(Base64.encode((byte[])object, (boolean)true));
            element2.setAttributeNode(attr4);
            Attr attr5 = document.createAttribute("hexhash");
            attr5.setValue(AOUtil.hexify((byte[])object, (boolean)false) + "h");
            element2.setAttributeNode(attr5);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory exception = TransformerFactory.newInstance();
            object = exception.newTransformer();
            ((Transformer)object).setOutputProperty("omit-xml-declaration", "no");
            ((Transformer)object).setOutputProperty("method", "xml");
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).setOutputProperty("encoding", this.getCharset().name());
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(stringWriter));
        }
        catch (Exception exception) {
            throw new DocumentException("Error al codificar el XML", exception);
        }
        return stringWriter.toString().getBytes(this.getCharset());
    }

    @Override
    void load(byte[] byArray) throws DocumentException, IOException, CorruptedDocumentException {
        Document document;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            object4 = DocumentBuilderFactory.newInstance();
            object3 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
            object2 = new ByteArrayInputStream(byArray);
            object = null;
            try {
                XmlHashDocument.validateAgainstXSD((InputStream)object2, CheckHashDirDialog.class.getResourceAsStream("/schemas/folderhashes.xsd"));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
            document = ((DocumentBuilder)object3).parse(new ByteArrayInputStream(byArray));
            object2 = document.getXmlEncoding();
            if (object2 != null) {
                this.setCharset(Charset.forName((String)object2));
            }
            document.getDocumentElement().normalize();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new DocumentException("El documento no es un XML valido", exception);
        }
        object4 = new HashMap();
        try {
            object3 = document.getElementsByTagName("entries");
            object2 = object3.item(0);
            this.setAlgorithm(object2.getAttributes().getNamedItem("hashAlgorithm").getNodeValue());
            this.setRecursive(Boolean.parseBoolean(object2.getAttributes().getNamedItem("recursive").getNodeValue()));
            object = document.getElementsByTagName("entry");
            for (int i = 0; i < object.getLength(); ++i) {
                byte[] byArray2;
                Node node = object.item(i);
                String string = node.getAttributes().getNamedItem("name").getNodeValue();
                byte[] byArray3 = Base64.decode((String)node.getAttributes().getNamedItem("hash").getNodeValue(), (boolean)true);
                if (!Arrays.equals(byArray3, byArray2 = HexUtils.hexStringToByteArray(node.getAttributes().getNamedItem("hexhash").getNodeValue()))) {
                    throw new CorruptedDocumentException("Se han encontrado que se han declarado dos hashes distintos para un fichero. Uno en hexadecimal y otro en Base 64");
                }
                object4.put(string, byArray3);
            }
        }
        catch (CorruptedDocumentException corruptedDocumentException) {
            throw corruptedDocumentException;
        }
        catch (Exception exception) {
            throw new DocumentException("El formato del documento no es el esperado", exception);
        }
        this.setHashes((Map<String, byte[]>)object4);
    }

    private static void validateAgainstXSD(InputStream inputStream, InputStream inputStream2) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(inputStream2));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inputStream));
    }
}

