/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashDocument;
import es.gob.afirma.plugin.hash.HexUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TxtHashDocument
extends HashDocument {
    private static final String LINE_HEADER_PREFIX = ";";
    private static final String LINE_HEADER_CHARSET = ";charset=";
    private static final String LINE_HEADER_ALGORITHM = ";hashAlgorithm=";
    private static final String LINE_HEADER_RECURSIVE = ";recursive=";
    private static final Logger LOGGER = Logger.getLogger(TxtHashDocument.class.getName());

    @Override
    public byte[] generate() throws DocumentException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LINE_HEADER_CHARSET).append(this.getCharset()).append("\r\n").append(LINE_HEADER_ALGORITHM).append(this.getAlgorithm()).append("\r\n").append(LINE_HEADER_RECURSIVE).append(this.isRecursive()).append("\r\n");
        Map<String, byte[]> map = this.getHashes();
        for (String string : map.keySet()) {
            stringBuilder.append(string).append(LINE_HEADER_PREFIX).append(AOUtil.hexify((byte[])map.get(string), (boolean)false)).append("\r\n");
        }
        return stringBuilder.toString().getBytes(this.getCharset());
    }

    @Override
    void load(byte[] byArray) throws DocumentException, IOException {
        Object object;
        Object object2;
        Charset charset = StandardCharsets.UTF_8;
        if (byArray.length > 30) {
            object2 = new String(byArray, 0, 30);
            if (((String)object2).startsWith(LINE_HEADER_CHARSET) && ((String)object2).indexOf("\r") > 0) {
                object = ((String)object2).substring(LINE_HEADER_CHARSET.length(), ((String)object2).indexOf("\r"));
                charset = Charset.forName((String)object);
            }
        } else {
            throw new DocumentException("No dispone de la longitud minima para considerarlo un documento de hashes TXT");
        }
        object2 = new ByteArrayInputStream(byArray);
        object = null;
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            boolean bl = true;
            do {
                if ((string = bufferedReader.readLine()).startsWith(LINE_HEADER_PREFIX)) {
                    if (string.startsWith(LINE_HEADER_ALGORITHM)) {
                        this.setAlgorithm(string.substring(LINE_HEADER_ALGORITHM.length()));
                        continue;
                    }
                    if (string.startsWith(LINE_HEADER_RECURSIVE)) {
                        this.setRecursive(Boolean.parseBoolean(string.substring(LINE_HEADER_RECURSIVE.length())));
                        continue;
                    }
                    if (!string.startsWith(LINE_HEADER_CHARSET)) continue;
                    try {
                        this.setCharset(Charset.forName(string.substring(LINE_HEADER_CHARSET.length())));
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Juego de caracteres no reconocido. Se usara el por defecto: " + this.getCharset(), exception);
                    }
                    continue;
                }
                bl = false;
            } while (bl);
            Map<String, byte[]> map = this.getHashes();
            while (string != null) {
                if (string.length() > 0) {
                    int n = string.indexOf(LINE_HEADER_PREFIX);
                    if (n <= 0 || n == string.length() - 1) {
                        throw new DocumentException("Se encontro una linea de hash no compatible");
                    }
                    byte[] byArray2 = HexUtils.hexStringToByteArray(string.substring(n + 1));
                    map.put(string.substring(0, n), byArray2);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object != null) {
                    try {
                        ((ByteArrayInputStream)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((ByteArrayInputStream)object2).close();
                }
            }
        }
    }
}

