/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

public class HexUtils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String HEX_SUFFIX = "h";

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length() % 2 == 1 && string.endsWith(HEX_SUFFIX) ? string.length() - 1 : string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        return HexUtils.byteArrayToHexString(byArray, false);
    }

    public static String byteArrayToHexString(byte[] byArray, boolean bl) {
        int n = bl ? byArray.length * 2 + 1 : byArray.length * 2;
        char[] cArray = new char[n];
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i * 2] = HEX_ARRAY[n2 >>> 4];
            cArray[i * 2 + 1] = HEX_ARRAY[n2 & 0xF];
        }
        if (bl) {
            cArray[cArray.length - 1] = HEX_SUFFIX.charAt(0);
        }
        return new String(cArray);
    }

    public static boolean isHexadecimal(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        String string = new String(byArray);
        boolean bl = string.endsWith(HEX_SUFFIX);
        return bl && (byArray.length - 1) % 2 == 0 && string.substring(0, string.length() - 1).matches("^[0-9a-fA-F]+$") || !bl && byArray.length % 2 == 0 && string.matches("^[0-9a-fA-F]+$");
    }
}

