/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.plugin.hash.DigestManager;
import es.gob.afirma.plugin.hash.DigestManagerInputStream;
import es.gob.afirma.standalone.plugins.AfirmaPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

public final class HashUtil {
    private static final Logger LOGGER = Logger.getLogger(HashUtil.class.getName());

    private HashUtil() {
    }

    static byte[] getFileHash(String string, Path path) throws NoSuchAlgorithmException, IOException {
        return HashUtil.getFileHash(string, path.toFile());
    }

    static byte[] getFileHash(String string, String string2) throws NoSuchAlgorithmException, IOException {
        return HashUtil.getFileHash(string, new File(string2));
    }

    public static byte[] getFileHash(String string, File file) throws NoSuchAlgorithmException, IOException {
        byte[] byArray;
        DigestManager digestManager = new DigestManager(string, null);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             DigestManagerInputStream digestManagerInputStream = new DigestManagerInputStream(fileInputStream, digestManager);){
            digestManagerInputStream.readOptimized(0x1900000);
            byArray = digestManagerInputStream.digest();
        }
        return byArray;
    }

    public static File getApplicationDirectory() {
        try {
            return new File(AfirmaPlugin.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warning("No se pudo localizar el directorio del fichero en ejecucion: " + uRISyntaxException);
            return null;
        }
    }

    public static File getWindowsAlternativeAppDir() {
        String string = System.getenv("ALLUSERSPROFILE");
        return new File(string, "AutoFirma");
    }
}

