/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.plugin.hash.CheckHashDirDialog;
import es.gob.afirma.plugin.hash.CheckHashFileDialog;
import es.gob.afirma.plugin.hash.CreateHashDirDialog;
import es.gob.afirma.plugin.hash.CreateHashFileDialog;
import es.gob.afirma.plugin.hash.HashReport;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.standalone.plugins.UIFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.SwingWorker;

public final class HashUIHelper {
    private static final Logger LOGGER = Logger.getLogger(HashUIHelper.class.getName());
    private static final String DEFAULT_HASH_ALGORITHM = "SHA-256";
    private static final CreateHashFileDialog.HashFormat DEFAULT_HASH_FORMAT = CreateHashFileDialog.HashFormat.HEX;
    private static final boolean DEFAULT_COPY_TO_CLIPBOARD = true;
    private static final String REPORT_EXT = "hashreport";

    public static void checkHashUI(File file, File file2) {
        File file3;
        if (file == null) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.4"), (String)Messages.getString("HashHelper.1"), (int)0, null);
            return;
        }
        if (!file.exists()) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.5"), (String)Messages.getString("HashHelper.1"), (int)0, null);
            return;
        }
        if (!file.canRead()) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.3"), (String)Messages.getString("HashHelper.1"), (int)0, null);
            return;
        }
        if (file.isDirectory()) {
            HashReport hashReport;
            Object object;
            File file4;
            if (file2 != null && file2.isFile()) {
                file4 = file2;
            } else {
                try {
                    file4 = AOUIFactory.getLoadFiles((String)Messages.getString("HashHelper.10"), (String)(file2 != null ? file2.getParent() : file.getParent()), (String)(file2 != null ? file2.getName() : null), (String[])new String[]{"hashfiles", "txthashfiles"}, (String)Messages.getString("HashHelper.15"), (boolean)false, (boolean)false, (Object)HashUIHelper.getDialogIcon(), null)[0];
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    return;
                }
            }
            try {
                try {
                    object = UIFactory.getWaitingDialog(null, (String)Messages.getString("CreateHashFiles.21"), (String)Messages.getString("CreateHashFiles.22"));
                }
                catch (Exception exception) {
                    object = null;
                }
                CheckHashWorker checkHashWorker = new CheckHashWorker(file, file4, (JDialog)object);
                checkHashWorker.execute();
                if (object != null) {
                    ((Dialog)object).setVisible(true);
                }
                if (!(hashReport = (HashReport)checkHashWorker.get()).hasErrors()) {
                    AOUIFactory.showMessageDialog(null, (Object)Messages.getString("CheckHashDialog.2"), (String)Messages.getString("CheckHashDialog.3"), (int)1);
                } else {
                    AOUIFactory.showMessageDialog(null, (Object)Messages.getString("CheckHashFiles.18"), (String)Messages.getString("CheckHashFiles.17"), (int)2);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashFiles.2"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)outOfMemoryError);
                LOGGER.log(Level.SEVERE, "Fichero demasiado grande: " + outOfMemoryError);
                return;
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                return;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error comprobando las huellas digitales del directorio '" + file.getAbsolutePath() + "' con el fichero: " + file4.getAbsolutePath(), exception);
                AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashDialog.6"), (String)Messages.getString("CheckHashDialog.7"), (int)0, (Throwable)exception);
                return;
            }
            try {
                object = CheckHashDirDialog.generateXMLReport(hashReport).getBytes(hashReport.getCharset());
            }
            catch (Exception exception) {
                AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashDialog.20"), (String)Messages.getString("CheckHashDialog.7"), (int)0, (Throwable)exception);
                return;
            }
            try {
                HashUIHelper.showSaveReportDialog((byte[])object, file.getParent(), null);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                return;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error guardado el informe de comprobacion de hashes", exception);
                AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashDialog.19"), (String)Messages.getString("CheckHashDialog.7"), (int)0, (Throwable)exception);
                return;
            }
        }
        if (file2 != null && file2.isFile()) {
            file3 = file2;
        } else {
            try {
                file3 = AOUIFactory.getLoadFiles((String)Messages.getString("HashHelper.7"), (String)(file2 != null ? file2.getParent() : file.getParent()), (String)(file2 != null ? file2.getName() : null), (String[])new String[]{"hash", "hashb64", "hexhash"}, (String)Messages.getString("HashHelper.16"), (boolean)false, (boolean)false, (Object)HashUIHelper.getDialogIcon(), null)[0];
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                return;
            }
        }
        try {
            if (CheckHashFileDialog.checkHash(file3.getAbsolutePath(), file.getAbsolutePath())) {
                AOUIFactory.showMessageDialog(null, (Object)Messages.getString("HashHelper.11"), (String)Messages.getString("HashHelper.12"), (int)1);
            } else {
                AOUIFactory.showMessageDialog(null, (Object)Messages.getString("HashHelper.13"), (String)Messages.getString("HashHelper.14"), (int)2);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error comprobando la huella digital de fichero '" + LoggerUtil.getCleanUserHomePath((String)file.getAbsolutePath()) + "' con la huella guardada en " + file3.getAbsolutePath(), exception);
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.8"), (String)Messages.getString("HashHelper.1"), (int)0, (Throwable)exception);
            return;
        }
    }

    public static void createHashUI(File file, File file2, String string, String string2, boolean bl) {
        if (file == null) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.0"), (String)Messages.getString("HashHelper.1"), (int)0, null);
            return;
        }
        if (!file.exists()) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.2"), (String)Messages.getString("HashHelper.1"), (int)0, null);
            return;
        }
        if (!file.canRead()) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("HashHelper.3"), (String)Messages.getString("HashHelper.1"), (int)0, null);
            return;
        }
        if (file.isDirectory()) {
            CreateHashDirDialog.doHashProcess(null, file, file2, string != null ? string : DEFAULT_HASH_ALGORITHM, string2, bl);
        } else {
            CreateHashFileDialog.doHashProcess(null, file, file2, string != null ? string : DEFAULT_HASH_ALGORITHM, string2 != null ? CreateHashFileDialog.HashFormat.fromString(string2) : DEFAULT_HASH_FORMAT, true);
        }
    }

    static void showSaveReportDialog(byte[] byArray, String string, Component component) throws IOException {
        AOUIFactory.getSaveDataToFile((byte[])byArray, (String)Messages.getString("CheckHashFiles.15"), (String)string, (String)(new File(Messages.getString("CheckHashFiles.16")).getName() + "." + REPORT_EXT), Collections.singletonList(new GenericFileFilter(new String[]{REPORT_EXT}, Messages.getString("CheckHashFiles.11") + " (*." + REPORT_EXT + ")")), (Object)component);
    }

    public static File loadDirToCheck() {
        return AOUIFactory.getLoadFiles((String)Messages.getString("CheckHashFiles.24"), null, null, null, (String)Messages.getString("CheckHashFiles.13"), (boolean)true, (boolean)false, (Object)HashUIHelper.getDialogIcon(), null)[0];
    }

    public static File loadFileToCheck() {
        return AOUIFactory.getLoadFiles((String)Messages.getString("CheckHashDialog.13"), null, null, null, (String)Messages.getString("CheckHashDialog.21"), (boolean)false, (boolean)false, (Object)HashUIHelper.getDialogIcon(), null)[0];
    }

    private static Image getDialogIcon() {
        Image image;
        try {
            image = UIFactory.getDefaultDialogIcon();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
            image = null;
        }
        return image;
    }

    private static class CheckHashWorker
    extends SwingWorker<HashReport, Void> {
        private final File dataFile;
        private final File hashFile;
        private final JDialog waitingDialog;

        public CheckHashWorker(File file, File file2, JDialog jDialog) {
            this.dataFile = file;
            this.hashFile = file2;
            this.waitingDialog = jDialog;
        }

        @Override
        protected HashReport doInBackground() throws Exception {
            HashReport hashReport = new HashReport();
            CheckHashDirDialog.checkHash(Paths.get(this.dataFile.toURI()), this.hashFile, hashReport);
            return hashReport;
        }

        @Override
        protected void done() {
            super.done();
            if (this.waitingDialog != null) {
                this.waitingDialog.dispose();
            }
        }
    }
}

