/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class HashReport {
    private final List<String> matchingHash = Collections.synchronizedList(new ArrayList());
    private final List<String> noMatchingHash = Collections.synchronizedList(new ArrayList());
    private final List<String> hashWithoutFile = Collections.synchronizedList(new ArrayList());
    private final List<String> fileWithoutHash = Collections.synchronizedList(new ArrayList());
    private boolean recursive;
    private String algorithm;
    private Charset charset = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMatchingHash(String string) {
        List<String> list = this.matchingHash;
        synchronized (list) {
            this.matchingHash.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportNoMatchingHash(String string) {
        List<String> list = this.noMatchingHash;
        synchronized (list) {
            this.noMatchingHash.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportHashWithoutFile(String string) {
        List<String> list = this.hashWithoutFile;
        synchronized (list) {
            this.hashWithoutFile.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFileWithoutHash(String string) {
        List<String> list = this.fileWithoutHash;
        synchronized (list) {
            this.fileWithoutHash.add(string);
        }
    }

    public Iterator<String> getMatchingHashIterator() {
        return this.matchingHash.iterator();
    }

    public Iterator<String> getNoMatchingHashIterator() {
        return this.noMatchingHash.iterator();
    }

    public Iterator<String> getHashWithoutFileIterator() {
        return this.hashWithoutFile.iterator();
    }

    public Iterator<String> getFileWithoutHashIterator() {
        return this.fileWithoutHash.iterator();
    }

    public boolean hasErrors() {
        return this.fileWithoutHash.size() > 0 || this.hashWithoutFile.size() > 0 || this.noMatchingHash.size() > 0;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public int getProcessedFilesCount() {
        return this.matchingHash.size() + this.noMatchingHash.size();
    }
}

