/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.plugin.hash.HashUtil;
import es.gob.afirma.standalone.plugins.AfirmaPlugin;
import es.gob.afirma.standalone.plugins.PluginControlledException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HashPlugin
extends AfirmaPlugin {
    private static final String REPLACE_PATH_BAT = "$$PATH_BAT$$";
    private static final String REPLACE_AUTOFIRMA_EXE = "$$AUTOFIRMA_EXE$$";
    private static final String EXECUTOR_BAT_FILENAME = "execute.bat";
    private static final String APP_EXE_FILENAME = "AutoFirma.exe";
    private static final Logger LOGGER = Logger.getLogger(HashPlugin.class.getName());

    public void install() throws PluginControlledException {
        if (Platform.getOS() == Platform.OS.WINDOWS) {
            HashPlugin.execRegistryScript("register.bat");
        }
    }

    public void uninstall() throws PluginControlledException {
        if (Platform.getOS() == Platform.OS.WINDOWS) {
            HashPlugin.execRegistryScript("unregister.bat");
        }
    }

    private static void execRegistryScript(String string) throws PluginControlledException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file = HashUtil.getApplicationDirectory();
        File file2 = Files.isWritable(file.toPath()) ? file : HashUtil.getWindowsAlternativeAppDir();
        File file3 = new File(file2, "hashplugin");
        file3.mkdirs();
        File file4 = new File(file3, string);
        try {
            object5 = new FileOutputStream(file4);
            object4 = null;
            try {
                object3 = HashPlugin.class.getResourceAsStream("/es/gob/afirma/plugin/hash/registryInstallation/" + string);
                object2 = null;
                try {
                    object = AOUtil.getDataFromInputStream((InputStream)object3);
                    ((FileOutputStream)object5).write((byte[])object);
                    ((OutputStream)object5).flush();
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object2 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object3).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object5 != null) {
                    if (object4 != null) {
                        try {
                            ((FileOutputStream)object5).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)object5).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new PluginControlledException("No se pudo copiar a disco el script de modificacion del registro. Se abortara su ejecucion", (Throwable)exception);
        }
        object5 = new File(file3, EXECUTOR_BAT_FILENAME);
        try {
            object4 = new FileOutputStream((File)object5);
            object3 = null;
            try {
                object2 = HashPlugin.class.getResourceAsStream("/es/gob/afirma/plugin/hash/registryInstallation/execute.bat");
                object = null;
                try {
                    byte[] byArray = AOUtil.getDataFromInputStream((InputStream)object2);
                    String string2 = new String(byArray);
                    File file5 = new File(file, APP_EXE_FILENAME);
                    string2 = string2.replace(REPLACE_PATH_BAT, file4.getAbsolutePath().replace("\\", "\\\\")).replace(REPLACE_AUTOFIRMA_EXE, file5.getAbsolutePath().replace("\\", "\\\\"));
                    ((FileOutputStream)object4).write(string2.getBytes());
                    ((OutputStream)object4).flush();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object2).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            ((FileOutputStream)object4).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)object4).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new PluginControlledException("No se pudo copiar a disco el script para la ejecucion de los cambios en el registro con permisos de administrador. Se abortara su ejecucion", (Throwable)exception);
        }
        try {
            object4 = new ProcessBuilder(((File)object5).getAbsolutePath()).start();
            ((Process)object4).waitFor();
            ((Process)object4).destroyForcibly();
        }
        catch (Exception exception) {
            throw new PluginControlledException("Error durante la ejecucion del proceso de instalacion de los recursos para el plugin", (Throwable)exception);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Se interrumpio la espera a la finalizacion del script", exception);
        }
        try {
            HashPlugin.deleteFile(file3);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "No se pudo eliminar el directorio con los recursos del plugin", iOException);
        }
    }

    private static void deleteFile(File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                HashPlugin.deleteFile(file2);
            }
        }
        Files.delete(file.toPath());
    }
}

