/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.plugin.hash.CorruptedDocumentException;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashDocument;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HashDocumentFactory {
    static final String FORMAT_XML = "xml";
    static final String FORMAT_CSV = "csv";
    static final String FORMAT_TXT = "txt";
    private static final String EXT_HASHFILES_XML = "hashfiles";
    private static final String EXT_HASHFILES_TXT = "txthashfiles";
    private static final String CLASS_HASHDOCUMENT_XML = "es.gob.afirma.plugin.hash.XmlHashDocument";
    private static final String CLASS_HASHDOCUMENT_TXT = "es.gob.afirma.plugin.hash.TxtHashDocument";
    private static final String CLASS_HASHDOCUMENT_CSV = "es.gob.afirma.plugin.hash.CsvHashDocument";
    private static final String[] HASH_DOCUMENT_CLASSES = new String[]{"es.gob.afirma.plugin.hash.XmlHashDocument", "es.gob.afirma.plugin.hash.TxtHashDocument"};
    private static final Logger LOGGER = Logger.getLogger(HashDocumentFactory.class.getName());

    public static HashDocument getHashDocument(String string) {
        HashDocument hashDocument;
        if (string == null) {
            throw new IllegalArgumentException("El formato de documento no puede ser nulo");
        }
        switch (string) {
            case "xml": {
                hashDocument = HashDocumentFactory.loadHashDocumentClass(CLASS_HASHDOCUMENT_XML);
                break;
            }
            case "txt": {
                hashDocument = HashDocumentFactory.loadHashDocumentClass(CLASS_HASHDOCUMENT_TXT);
                break;
            }
            case "csv": {
                hashDocument = HashDocumentFactory.loadHashDocumentClass(CLASS_HASHDOCUMENT_CSV);
                break;
            }
            default: {
                throw new IllegalArgumentException("El formato de documentos de hash '" + string + "' no esta soportado");
            }
        }
        return hashDocument;
    }

    static HashDocument loadDocument(byte[] byArray, String string) throws DocumentException, CorruptedDocumentException {
        String string2 = null;
        switch (string) {
            case "xml": 
            case "hashfiles": {
                string2 = CLASS_HASHDOCUMENT_XML;
                break;
            }
            case "txt": 
            case "txthashfiles": {
                string2 = CLASS_HASHDOCUMENT_TXT;
                break;
            }
        }
        return HashDocumentFactory.loadHashDocument(byArray, string2);
    }

    private static HashDocument loadHashDocument(byte[] byArray, String string) throws DocumentException, CorruptedDocumentException {
        if (string != null) {
            HashDocument hashDocument = HashDocumentFactory.loadHashDocumentClass(string);
            try {
                hashDocument.load(byArray);
                return hashDocument;
            }
            catch (CorruptedDocumentException corruptedDocumentException) {
                LOGGER.severe("Se ha identificado que el documento esta corrupto o ha sido manipulado");
                throw corruptedDocumentException;
            }
            catch (IOException iOException) {
                LOGGER.warning("No se pudo cargar el documento. Se considerara que el formato no era el esperado y se continuara con el resto de formatos");
            }
            catch (Exception exception) {
                LOGGER.warning("El formato del documento de hashes de entrada no se corresponde con el que declara");
            }
        }
        for (String string2 : HASH_DOCUMENT_CLASSES) {
            if (string2 == string) continue;
            HashDocument hashDocument = HashDocumentFactory.loadHashDocumentClass(string);
            try {
                return hashDocument;
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, String.format("El manejador %s no soporta el fichero de hashes indicado", string2));
            }
        }
        throw new DocumentException("El formato del documento de hashes seleccionado no esta soportado");
    }

    private static HashDocument loadHashDocumentClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (HashDocument)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Falta una clase interna en la aplicacion", exception);
        }
    }
}

