/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.plugin.hash.DigestManager;
import java.io.IOException;
import java.io.InputStream;

public class DigestManagerInputStream
extends InputStream {
    private final InputStream myInputStream;
    private final DigestManager myMessageDigest;

    public DigestManagerInputStream(InputStream inputStream, DigestManager digestManager) {
        this.myInputStream = inputStream;
        this.myMessageDigest = digestManager;
    }

    @Override
    public int read() throws IOException {
        int n = this.myInputStream.read();
        if (n != -1) {
            this.myMessageDigest.addDataToCompute((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.myInputStream.read(byArray);
        if (n > 0) {
            this.myMessageDigest.addDataToCompute(byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.myInputStream.read(byArray, n, n2);
        if (n3 > 0) {
            this.myMessageDigest.addDataToCompute(byArray, n, n3);
        }
        return n3;
    }

    public void readOptimized(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.read(byArray);
        while (n2 > 0) {
            n2 = this.read(byArray);
        }
    }

    public byte[] digest() {
        return this.myMessageDigest.computeHash();
    }

    @Override
    public void close() throws IOException {
        this.myInputStream.close();
    }
}

