/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class DigestManager {
    private MessageDigest md = null;
    public static final int SIZE_1KB = 1000;
    public static final int SIZE_10KB = 10000;
    public static final int SIZE_100KB = 100000;
    public static final int SIZE_1MB = 1000000;
    public static final int SIZE_5MB = 0x500000;
    public static final int SIZE_15MB = 0xF00000;
    public static final int SIZE_25MB = 0x1900000;

    public DigestManager(String string, Provider provider) throws NoSuchAlgorithmException {
        this.md = provider != null ? MessageDigest.getInstance(string, provider) : MessageDigest.getInstance(string);
    }

    public void addDataToCompute(byte by) {
        this.md.update(by);
    }

    public void addDataToCompute(byte[] byArray) {
        this.md.update(byArray);
    }

    public void addDataToCompute(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public void addDataToCompute(String string) {
        this.md.update(string.getBytes());
    }

    public byte[] computeHash(byte[] byArray) {
        return this.md.digest(byArray);
    }

    public byte[] computeHash(String string) {
        return this.md.digest(string.getBytes());
    }

    public byte[] computeHash() {
        return this.md.digest();
    }

    public byte[] computeHashOptimized(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) > 0) {
            this.addDataToCompute(byArray, 0, n2);
        }
        return this.computeHash();
    }

    public static synchronized boolean equalHashes(byte[] byArray, byte[] byArray2) {
        return MessageDigest.isEqual(byArray, byArray2);
    }
}

