/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashDocument;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Logger;

public class CsvHashDocument
extends HashDocument {
    private static final Logger LOGGER = Logger.getLogger(CsvHashDocument.class.getName());

    @Override
    public byte[] generate() throws DocumentException {
        Map<String, byte[]> map = this.getHashes();
        if (map == null || map.size() < 1) {
            LOGGER.warning("No hay huellas, se genera un CSV vacio");
            return new byte[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            stringBuilder.append("\"" + entry.getKey() + "\",\"" + AOUtil.hexify((byte[])entry.getValue(), (boolean)false) + "h\"\r\n");
        }
        return stringBuilder.toString().getBytes(this.getCharset() != null ? this.getCharset() : StandardCharsets.UTF_8);
    }

    @Override
    void load(byte[] byArray) throws DocumentException {
        throw new UnsupportedOperationException("No se soporta la validacion de documentos CSV de hashes");
    }
}

