/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.plugin.hash.FileUtils;
import es.gob.afirma.plugin.hash.HashUtil;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.standalone.plugins.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public final class CreateHashFileDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 3581001930027153381L;
    static final Logger LOGGER = Logger.getLogger(CreateHashFileDialog.class.getName());
    private static final String[] HASH_ALGOS = new String[]{"SHA-256", "SHA-1", "SHA-384", "SHA-512"};
    private final Properties config;
    private final JComboBox<String> hashAlgorithms = new JComboBox<String>(HASH_ALGOS);
    private final JComboBox<HashFormat> hashFormats = new JComboBox<HashFormat>(HashFormat.getHashFormats());
    private final JTextField fileTextField = new JTextField();
    final JCheckBox copyToClipBoardCheckBox = new JCheckBox(Messages.getString("CreateHashDialog.19"));

    String getSelectedHashAlgorithm() {
        Object object = this.hashAlgorithms.getSelectedItem();
        if (object == null) {
            object = HASH_ALGOS[0];
        }
        return object.toString();
    }

    HashFormat getSelectedHashFormat() {
        return (HashFormat)((Object)this.hashFormats.getSelectedItem());
    }

    JTextField getFileTextField() {
        return this.fileTextField;
    }

    boolean isCopyToClipBoardChecked() {
        return this.copyToClipBoardCheckBox.isSelected();
    }

    public static void startHashCreation(Window window, Properties properties) {
        CreateHashFileDialog createHashFileDialog = new CreateHashFileDialog(window, properties);
        createHashFileDialog.setSize(600, 350);
        createHashFileDialog.setResizable(false);
        createHashFileDialog.setLocationRelativeTo(window);
        createHashFileDialog.setVisible(true);
    }

    private CreateHashFileDialog(Window window, Properties properties) {
        super(window);
        this.config = properties;
        this.setTitle(Messages.getString("CreateHashDialog.15"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.createUI(window);
    }

    void createUI(Window window) {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 15, 0, 10);
        try {
            this.setIconImage(UIFactory.getDefaultDialogIcon());
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
        }
        this.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashDialog.1"));
        JLabel jLabel = new JLabel(Messages.getString("CreateHashDialog.2"));
        jLabel.setLabelFor(this.hashAlgorithms);
        this.hashAlgorithms.setSelectedItem(this.config.getProperty("createHashAlgorithm", HASH_ALGOS[0]));
        this.hashAlgorithms.addActionListener(actionEvent -> this.config.setProperty("createHashAlgorithm", this.getSelectedHashAlgorithm()));
        this.hashAlgorithms.addKeyListener(this);
        JLabel jLabel2 = new JLabel(Messages.getString("CreateHashDialog.0"));
        jLabel2.setLabelFor(this.hashFormats);
        this.hashFormats.setSelectedItem((Object)HashFormat.fromString(this.config.getProperty("createHashFormat")));
        this.hashFormats.addActionListener(actionEvent -> this.config.setProperty("createHashFormat", this.getSelectedHashFormat().toString()));
        this.hashFormats.addKeyListener(this);
        this.copyToClipBoardCheckBox.addActionListener(actionEvent -> this.config.setProperty("createHashCopyToClipBoard", Boolean.toString(this.isCopyToClipBoardChecked())));
        this.copyToClipBoardCheckBox.setSelected(Boolean.parseBoolean(this.config.getProperty("createHashCopyToClipBoard")));
        this.copyToClipBoardCheckBox.addKeyListener(this);
        JLabel jLabel3 = new JLabel(Messages.getString("CreateHashDialog.3"));
        jLabel3.addKeyListener(this);
        jLabel3.setLabelFor(this.fileTextField);
        this.fileTextField.addKeyListener(this);
        this.fileTextField.setEditable(false);
        this.fileTextField.setFocusable(false);
        this.fileTextField.setColumns(10);
        JButton jButton = new JButton(Messages.getString("CreateHashDialog.4"));
        jButton.addKeyListener(this);
        JButton jButton2 = new JButton(Messages.getString("CreateHashDialog.5"));
        jButton2.addKeyListener(this);
        jButton2.setMnemonic('E');
        jButton2.addActionListener(actionEvent -> {
            try {
                this.getFileTextField().setText(AOUIFactory.getLoadFiles((String)Messages.getString("CreateHashDialog.6"), null, null, null, (String)Messages.getString("CreateHashDialog.7"), (boolean)false, (boolean)false, (Object)CreateHashFileDialog.getDialogIcon(), (Object)this)[0].getAbsolutePath());
                jButton.setEnabled(true);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                // empty catch block
            }
        });
        jButton2.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashDialog.12"));
        jButton2.addKeyListener(this);
        jButton.setEnabled(false);
        jButton.setMnemonic('G');
        jButton.addActionListener(actionEvent -> {
            try {
                CreateHashFileDialog.doHashProcess(window, new File(this.getFileTextField().getText()), null, this.getSelectedHashAlgorithm(), this.getSelectedHashFormat(), this.isCopyToClipBoardChecked());
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                return;
            }
            this.setVisible(false);
            this.dispose();
        });
        jButton.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashDialog.11"));
        JButton jButton3 = new JButton(Messages.getString("CreateHashDialog.16"));
        jButton3.setMnemonic('C');
        jButton3.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        jButton3.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashDialog.17"));
        jButton3.addKeyListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            jPanel.add(jButton3);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton3);
        }
        container.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add((Component)this.fileTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        container.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(20, 15, 0, 10);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add(this.hashAlgorithms, gridBagConstraints);
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add(this.hashFormats, gridBagConstraints);
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add((Component)this.copyToClipBoardCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
    }

    static void doHashProcess(Window window, File file, File file2, String string, HashFormat hashFormat, boolean bl) throws AOCancelledOperationException {
        byte[] byArray;
        String string2;
        byte[] byArray2;
        JDialog jDialog;
        try {
            jDialog = UIFactory.getWaitingDialog((Component)window, (String)Messages.getString("CreateHashFiles.18"), (String)Messages.getString("CreateHashFiles.20"));
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el dialogo de espera: " + exception);
            jDialog = null;
        }
        try {
            byArray2 = CreateHashFileDialog.calculateHash(file, string, jDialog);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error generando o guardando la huella digital", exception);
            AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashDialog.13"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)exception);
            return;
        }
        switch (hashFormat) {
            case HEX: {
                string2 = "hexhash";
                byArray = (AOUtil.hexify((byte[])byArray2, (boolean)false) + "h").getBytes();
                break;
            }
            case BASE64: {
                string2 = "hashb64";
                byArray = Base64.encode((byte[])byArray2).getBytes();
                break;
            }
            case BINARY: {
                string2 = "hash";
                byArray = byArray2;
                break;
            }
            default: {
                throw new IllegalStateException("Formato de huella no contemplado: " + (Object)((Object)hashFormat));
            }
        }
        if (bl) {
            CreateHashFileDialog.copyToClipBoard(HashFormat.BINARY.equals((Object)hashFormat) ? AOUtil.hexify((byte[])byArray, (boolean)false) + "h" : new String(byArray));
        }
        try {
            AOUIFactory.getSaveDataToFile((byte[])byArray, (String)Messages.getString("CreateHashDialog.8"), (String)(file2 != null && file2.getParentFile() != null ? file2.getParentFile().getAbsolutePath() : null), (String)(file2 != null ? file2.getName() : FileUtils.getCanonicalFile(file).getName() + "." + string2), Collections.singletonList(new GenericFileFilter(new String[]{string2}, Messages.getString("CreateHashDialog.9") + " (*." + string2 + ")")), (Object)window);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            throw aOCancelledOperationException;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error durante el guardado del hash", exception);
            AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashDialog.27"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)exception);
        }
    }

    public static byte[] calculateHash(final File file, final String string, final Dialog dialog) throws InterruptedException, ExecutionException {
        SwingWorker<byte[], Void> swingWorker = new SwingWorker<byte[], Void>(){

            @Override
            protected byte[] doInBackground() throws FileNotFoundException, IOException, NoSuchAlgorithmException {
                long l = new Date().getTime();
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    byte[] byArray = HashUtil.getFileHash(string, file);
                    long l2 = new Date().getTime() - l;
                    LOGGER.info("Tiempo total de generacion del hash: " + (double)l2 / 1000.0 + " seg");
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
            }

            @Override
            protected void done() {
                super.done();
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        };
        swingWorker.execute();
        if (dialog != null) {
            dialog.setVisible(true);
        }
        return (byte[])swingWorker.get();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 27 && !Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    static void copyToClipBoard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private static Image getDialogIcon() {
        Image image;
        try {
            image = UIFactory.getDefaultDialogIcon();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
            image = null;
        }
        return image;
    }

    static enum HashFormat {
        HEX(Messages.getString("CreateHashDialog.21")),
        BASE64(Messages.getString("CreateHashDialog.22")),
        BINARY(Messages.getString("CreateHashDialog.23"));

        private static final String HEX_ALT_NAME = "hex";
        private static final String BASE64_ALT_NAME = "b64";
        private static final String BINARY_ALT_NAME = "bin";
        private final String name;

        private HashFormat(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        static HashFormat[] getHashFormats() {
            return new HashFormat[]{HEX, BASE64, BINARY};
        }

        static HashFormat getDefaultFormat() {
            return HEX;
        }

        static HashFormat fromString(String string) {
            if (HEX.toString().equals(string) || HEX_ALT_NAME.equalsIgnoreCase(string)) {
                return HEX;
            }
            if (BASE64.toString().equals(string) || BASE64_ALT_NAME.equalsIgnoreCase(string)) {
                return BASE64;
            }
            if (BINARY.toString().equals(string) || BINARY_ALT_NAME.equalsIgnoreCase(string)) {
                return BINARY;
            }
            LOGGER.warning("Formato de huella desconocido, se usara el por defecto: " + string);
            return HashFormat.getDefaultFormat();
        }
    }
}

