/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.plugin.hash.CreateHashAction;
import es.gob.afirma.plugin.hash.FileUtils;
import es.gob.afirma.plugin.hash.HashDocument;
import es.gob.afirma.plugin.hash.HashDocumentFactory;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.standalone.plugins.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public final class CreateHashDirDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = -7224732001218823361L;
    static final Logger LOGGER = Logger.getLogger(CreateHashDirDialog.class.getName());
    private static final String[] HASH_ALGOS = new String[]{"SHA-256", "SHA-1", "SHA-384", "SHA-512"};
    private static final String FILEEXT_XML = "hashfiles";
    private static final String FILEEXT_TXT = "txthashfiles";
    private static final String FILEEXT_CSV = "csv";
    private static final String DEFAULT_FORMAT = "xml";
    private final JComboBox<String> hashAlgorithms = new JComboBox<String>(HASH_ALGOS);
    private final JTextField selectedFile = new JTextField();
    private final JButton examineButton = new JButton();
    private final JButton generateButton = new JButton();
    private final JCheckBox recursive = new JCheckBox(Messages.getString("CreateHashFiles.16"));
    private final Properties config;

    public static void startHashCreation(Window window, Properties properties) {
        CreateHashDirDialog createHashDirDialog = new CreateHashDirDialog(window, properties);
        createHashDirDialog.setSize(600, 250);
        createHashDirDialog.setResizable(false);
        createHashDirDialog.setLocationRelativeTo(window);
        createHashDirDialog.setVisible(true);
    }

    private CreateHashDirDialog(Window window, Properties properties) {
        super(window);
        this.config = properties;
        this.setTitle(Messages.getString("CreateHashFiles.0"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.createUI(window);
    }

    void createUI(Window window) {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.setLayout(new GridBagLayout());
        this.setLocationRelativeTo(window);
        try {
            this.setIconImage(UIFactory.getDefaultDialogIcon());
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
        }
        this.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashFiles.1"));
        JLabel jLabel = new JLabel(Messages.getString("CreateHashFiles.11"));
        this.examineButton.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashFiles.10"));
        this.examineButton.setText(Messages.getString("CreateHashFiles.10"));
        this.examineButton.setMnemonic('X');
        this.examineButton.addKeyListener(this);
        this.examineButton.addActionListener(actionEvent -> this.openSelectedFile());
        this.examineButton.setEnabled(true);
        this.selectedFile.setEditable(false);
        this.selectedFile.setFocusable(false);
        this.selectedFile.addKeyListener(this);
        JLabel jLabel2 = new JLabel(Messages.getString("CreateHashDialog.2"));
        this.hashAlgorithms.setSelectedItem(this.config.getProperty("createHashDirectoryAlgorithm", HASH_ALGOS[0]));
        this.hashAlgorithms.addKeyListener(this);
        this.hashAlgorithms.addActionListener(actionEvent -> this.config.setProperty("createHashDirectoryAlgorithm", this.getSelectedHashAlgorithm()));
        this.recursive.setSelected(Boolean.parseBoolean(this.config.getProperty("createHashDirectoryRecursive")));
        this.recursive.addKeyListener(this);
        this.recursive.addActionListener(actionEvent -> this.config.setProperty("createHashDirectoryRecursive", Boolean.toString(this.isRecursive())));
        this.recursive.setMnemonic('R');
        this.generateButton.setText(Messages.getString("CreateHashDialog.4"));
        this.generateButton.setMnemonic('G');
        this.generateButton.addKeyListener(this);
        this.generateButton.addActionListener(actionEvent -> {
            try {
                CreateHashDirDialog.doHashProcess(window, new File(this.getFileTextField().getText()), null, this.getSelectedHashAlgorithm(), DEFAULT_FORMAT, this.isRecursive());
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                return;
            }
            this.setVisible(false);
            this.dispose();
        });
        this.generateButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(Messages.getString("CreateHashDialog.16"));
        jButton.setMnemonic('C');
        jButton.addKeyListener(this);
        jButton.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        jButton.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashDialog.17"));
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            jPanel.add(jButton);
            jPanel.add(this.generateButton);
        } else {
            jPanel.add(this.generateButton);
            jPanel.add(jButton);
        }
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.selectedFile, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.examineButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        this.add(this.hashAlgorithms, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.recursive, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    static void doHashProcess(Component component, File file, File file2, String string, String string2, boolean bl) throws AOCancelledOperationException {
        JDialog jDialog;
        String string3 = string2 != null ? string2 : DEFAULT_FORMAT;
        try {
            jDialog = UIFactory.getWaitingDialog((Component)component, (String)Messages.getString("CreateHashFiles.18"), (String)Messages.getString("CreateHashFiles.20"));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No se ha podido cargar el dialogo de espera", exception);
            jDialog = null;
        }
        try {
            String string4;
            Map<String, byte[]> map = CreateHashDirDialog.calculateHashes(file, bl, string, jDialog);
            String string5 = CreateHashDirDialog.getDefaultExtension(string3);
            File file3 = AOUIFactory.getSaveDataToFile(null, (String)Messages.getString("CreateHashFiles.19"), (String)(file2 != null && file2.getParentFile() != null ? file2.getParentFile().getAbsolutePath() : null), (String)(file2 != null ? file2.getName() : FileUtils.getCanonicalFile(file).getName() + "." + string5), CreateHashDirDialog.buildFilterList(string5), (Object)component);
            String string6 = string4 = file3.getName().indexOf(46) == -1 ? "" : file3.getName().substring(file3.getName().lastIndexOf(46));
            String string7 = string4.equalsIgnoreCase(".csv") || string4.equalsIgnoreCase(".csv") ? DEFAULT_FORMAT : (string4.equalsIgnoreCase(".txthashfiles") || string4.equalsIgnoreCase(".txt") ? "txt" : DEFAULT_FORMAT);
            HashDocument hashDocument = HashDocumentFactory.getHashDocument(string7);
            hashDocument.setHashes(map);
            hashDocument.setRecursive(bl);
            hashDocument.setAlgorithm(string);
            hashDocument.setCharset(StandardCharsets.UTF_8);
            byte[] byArray = hashDocument.generate();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                ((OutputStream)fileOutputStream).write(byArray);
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudo guardar la informacion en el fichero indicado: " + exception);
                AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashFiles.3"), (String)Messages.getString("CreateHashFiles.19"), (int)0, (Throwable)exception);
            }
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            throw aOCancelledOperationException;
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof OutOfMemoryError) {
                AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashFiles.2"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)exception);
                LOGGER.severe("Fichero demasiado grande: " + exception.getCause());
            }
            AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashDialog.13"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)exception);
            LOGGER.log(Level.SEVERE, "Error generando o guardando la huella digital", exception);
        }
    }

    void openSelectedFile() {
        File file;
        Image image;
        try {
            image = UIFactory.getDefaultDialogIcon();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
            image = null;
        }
        this.setIconImage(image);
        try {
            file = AOUIFactory.getLoadFiles((String)Messages.getString("CreateHashFiles.11"), null, null, (String[])new String[0], (String)Messages.getString("CreateHashDialog.7"), (boolean)true, (boolean)false, (Object)image, (Object)this)[0];
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            return;
        }
        if (!file.canRead()) {
            AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashFiles.23"), (String)Messages.getString("CheckHashFiles.17"), (int)0, null);
            return;
        }
        this.selectedFile.setText(file.getAbsolutePath());
        this.generateButton.setEnabled(true);
    }

    public static Map<String, byte[]> calculateHashes(final File file, final boolean bl, final String string, final Dialog dialog) throws InterruptedException, ExecutionException {
        SwingWorker<Map<String, byte[]>, Void> swingWorker = new SwingWorker<Map<String, byte[]>, Void>(){

            @Override
            protected Map<String, byte[]> doInBackground() throws Exception {
                Map<String, byte[]> map = Collections.synchronizedMap(new HashMap());
                long l = new Date().getTime();
                ForkJoinPool forkJoinPool = new ForkJoinPool(10);
                CreateHashAction createHashAction = new CreateHashAction(file.toPath(), file, bl, string, map, forkJoinPool);
                forkJoinPool.invoke(createHashAction);
                createHashAction.join();
                long l2 = new Date().getTime() - l;
                LOGGER.info("Tiempo total de generacion en la hashes: " + (double)l2 / 1000.0 + " seg");
                LOGGER.info("Numero de ficheros procesados: " + map.size());
                return map;
            }

            @Override
            protected void done() {
                super.done();
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        };
        swingWorker.execute();
        if (dialog != null) {
            dialog.setVisible(true);
        }
        return (Map)swingWorker.get();
    }

    private static String getDefaultExtension(String string) {
        switch (string) {
            case "xml": {
                return FILEEXT_XML;
            }
            case "txt": {
                return FILEEXT_TXT;
            }
        }
        return null;
    }

    private static List<GenericFileFilter> buildFilterList(String string) {
        List<GenericFileFilter> list;
        GenericFileFilter[] genericFileFilterArray = new GenericFileFilter[]{new GenericFileFilter(new String[]{FILEEXT_XML}, Messages.getString("CreateHashDialog.26") + " (*." + FILEEXT_XML + ")"), new GenericFileFilter(new String[]{FILEEXT_TXT}, Messages.getString("CreateHashDialog.25") + " (*." + FILEEXT_TXT + ")")};
        if (string == null) {
            list = Arrays.asList(genericFileFilterArray);
        } else {
            list = new ArrayList<GenericFileFilter>();
            for (GenericFileFilter genericFileFilter : genericFileFilterArray) {
                if (!string.equals(genericFileFilter.getExtensions()[0])) continue;
                list.add(genericFileFilter);
            }
            for (GenericFileFilter genericFileFilter : genericFileFilterArray) {
                if (string.equals(genericFileFilter.getExtensions()[0])) continue;
                list.add(genericFileFilter);
            }
        }
        return list;
    }

    String getSelectedHashAlgorithm() {
        String string = (String)this.hashAlgorithms.getSelectedItem();
        if (string == null || string.isEmpty()) {
            string = HASH_ALGOS[0];
        }
        return this.hashAlgorithms.getSelectedItem().toString();
    }

    boolean isRecursive() {
        return this.recursive.isSelected();
    }

    JTextField getFileTextField() {
        return this.selectedFile;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 27 && !Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

