/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.plugin.hash.HashUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateHashAction
extends RecursiveAction {
    private static final long serialVersionUID = 9133180415134836622L;
    private static final Logger LOGGER = Logger.getLogger(CreateHashAction.class.getName());
    private static final Set<String> FILES_TO_AVOID = new HashSet<String>(Arrays.asList(".fseventsd", ".Spotlight-V100", ".Trashes", "._.Trashes", ".DS_Store", ".desktop", "thumbs.db", "$Recycle.Bin"));
    private final Path basePath;
    private final File dataFile;
    private final boolean recursive;
    private final String digestAlgorithm;
    private final Map<String, byte[]> result;
    private final ForkJoinPool pool;

    public CreateHashAction(Path path, File file, boolean bl, String string, Map<String, byte[]> map, ForkJoinPool forkJoinPool) {
        this.basePath = path;
        this.dataFile = file;
        this.recursive = bl;
        this.digestAlgorithm = string;
        this.result = map;
        this.pool = forkJoinPool;
    }

    @Override
    protected void compute() {
        if (this.dataFile.isFile()) {
            if (!this.dataFile.getName().contains("~$") && !FILES_TO_AVOID.contains(this.dataFile.getName())) {
                this.processing();
            }
        } else {
            ArrayList<CreateHashAction> arrayList = new ArrayList<CreateHashAction>();
            for (File file : this.dataFile.listFiles()) {
                if (!this.recursive && !file.isFile()) continue;
                arrayList.add(new CreateHashAction(this.basePath, file, this.recursive, this.digestAlgorithm, this.result, this.pool));
            }
            if (!this.pool.isShutdown()) {
                ForkJoinTask.invokeAll(arrayList);
            }
        }
    }

    private void processing() {
        try {
            byte[] byArray = HashUtil.getFileHash(this.digestAlgorithm, this.dataFile);
            this.result.put(this.basePath.relativize(Paths.get(this.dataFile.getAbsolutePath(), new String[0])).toString(), byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.SEVERE, "Se ha indicado un algoritmo de hash no soportado", noSuchAlgorithmException);
            this.pool.shutdown();
        }
        catch (Error | Exception throwable) {
            LOGGER.log(Level.SEVERE, "Error al calcular el hash de un fichero", throwable);
            this.pool.shutdown();
        }
    }
}

