/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.plugin.hash.HashUtil;
import es.gob.afirma.plugin.hash.HexUtils;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.standalone.plugins.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public final class CheckHashFileDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 2431770911918905439L;
    static final Logger LOGGER = Logger.getLogger(CheckHashFileDialog.class.getName());
    private static final int SIZE_WAIT = 50000000;
    private final JTextField textFieldHash = new JTextField();
    private final JTextField textFieldData = new JTextField();

    void setTextFieldHashText(String string) {
        this.textFieldHash.setText(string);
    }

    String getTextFieldHashText() {
        return this.textFieldHash.getText();
    }

    void setTextFieldDataText(String string) {
        this.textFieldData.setText(string);
    }

    String getTextFieldDataText() {
        return this.textFieldData.getText();
    }

    private CheckHashFileDialog(Window window) {
        super(window);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.createUI(window);
    }

    void createUI(Window window) {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 15, 0, 10);
        Image image = CheckHashFileDialog.getDialogIcon();
        this.setIconImage(image);
        this.setTitle(Messages.getString("CheckHashDialog.0"));
        JButton jButton = new JButton(Messages.getString("CheckHashDialog.1"));
        jButton.addKeyListener(this);
        jButton.setMnemonic('C');
        jButton.setEnabled(false);
        jButton.addActionListener(actionEvent -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (CheckHashFileDialog.checkHash(this.getTextFieldHashText(), this.getTextFieldDataText())) {
                    AOUIFactory.showMessageDialog((Object)this, (Object)Messages.getString("CheckHashDialog.2"), (String)Messages.getString("CheckHashDialog.3"), (int)1);
                } else {
                    AOUIFactory.showMessageDialog((Object)this, (Object)Messages.getString("CheckHashDialog.4"), (String)Messages.getString("CheckHashDialog.5"), (int)2);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashDialog.18"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)outOfMemoryError);
                LOGGER.log(Level.SEVERE, "Fichero demasiado grande", outOfMemoryError);
                return;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "No ha sido posible comprobar las huellas digitales", exception);
                AOUIFactory.showErrorMessage((Object)this, (String)Messages.getString("CheckHashDialog.6"), (int)0, (Throwable)exception);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.textFieldHash.addKeyListener(this);
        this.textFieldHash.setEditable(false);
        this.textFieldHash.setFocusable(false);
        this.textFieldHash.setColumns(10);
        JLabel jLabel = new JLabel(Messages.getString("CheckHashDialog.8"));
        jLabel.setLabelFor(this.textFieldHash);
        jLabel.addKeyListener(this);
        JButton jButton2 = new JButton(Messages.getString("CheckHashDialog.9"));
        jButton2.addKeyListener(this);
        jButton2.setMnemonic('x');
        jButton2.addActionListener(actionEvent -> {
            try {
                this.setTextFieldHashText(AOUIFactory.getLoadFiles((String)Messages.getString("CheckHashDialog.10"), null, null, (String[])new String[]{"hash", "hashb64", "hexhash"}, (String)Messages.getString("CheckHashDialog.14"), (boolean)false, (boolean)false, (Object)image, (Object)this)[0].getAbsolutePath());
                String string = this.getTextFieldDataText();
                if (string != null && !string.isEmpty()) {
                    jButton.setEnabled(true);
                }
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                // empty catch block
            }
        });
        this.textFieldData.addKeyListener(this);
        this.textFieldData.setEditable(false);
        this.textFieldData.setFocusable(false);
        this.textFieldData.setColumns(10);
        JLabel jLabel2 = new JLabel(Messages.getString("CheckHashDialog.11"));
        jLabel2.setLabelFor(this.textFieldData);
        jLabel2.addKeyListener(this);
        JButton jButton3 = new JButton(Messages.getString("CheckHashDialog.12"));
        jButton3.addKeyListener(this);
        jButton3.setMnemonic('E');
        jButton3.addActionListener(actionEvent -> {
            try {
                this.setTextFieldDataText(AOUIFactory.getLoadFiles((String)Messages.getString("CheckHashDialog.13"), null, null, null, (String)Messages.getString("CheckHashDialog.14"), (boolean)false, (boolean)false, (Object)image, (Object)this)[0].getAbsolutePath());
                String string = this.getTextFieldHashText();
                if (string != null && !string.isEmpty()) {
                    jButton.setEnabled(true);
                }
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                // empty catch block
            }
        });
        JButton jButton4 = new JButton(Messages.getString("CheckHashDialog.15"));
        jButton4.setMnemonic('C');
        jButton4.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        jButton4.getAccessibleContext().setAccessibleDescription(Messages.getString("CheckHashDialog.16"));
        jButton4.addKeyListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            jPanel.add(jButton4);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton4);
        }
        container.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        container.add((Component)this.textFieldData, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        container.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(30, 15, 0, 10);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add((Component)this.textFieldHash, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        container.add((Component)jButton2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(30, 10, 0, 10);
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
    }

    static boolean checkHash(String string, String string2) throws InterruptedException, ExecutionException {
        JDialog jDialog;
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            jDialog = UIFactory.getWaitingDialog(null, (String)Messages.getString("CreateHashFiles.21"), (String)Messages.getString("CreateHashFiles.22"));
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el dialogo de espera: " + exception);
            jDialog = null;
        }
        return CheckHashFileDialog.checkHash(new File(string), new File(string2), jDialog);
    }

    public static boolean checkHash(final File file, final File file2, final Dialog dialog) throws InterruptedException, ExecutionException {
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                byte[] byArray;
                byte[] byArray2;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    byArray2 = AOUtil.getDataFromInputStream((InputStream)fileInputStream);
                }
                if (Base64.isBase64((byte[])byArray2)) {
                    byArray2 = Base64.decode((byte[])byArray2, (int)0, (int)byArray2.length, (boolean)false);
                } else if (HexUtils.isHexadecimal(byArray2)) {
                    byArray2 = HexUtils.hexStringToByteArray(new String(byArray2).substring(0, byArray2.length - 1));
                }
                long l = new Date().getTime();
                try {
                    byArray = HashUtil.getFileHash(CheckHashFileDialog.getHashAlgorithm(byArray2), file2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new IOException(noSuchAlgorithmException);
                }
                long l2 = new Date().getTime() - l;
                LOGGER.info("Tiempo total de comprobacion del hash: " + (double)l2 / 1000.0 + " seg");
                return Arrays.equals(byArray2, byArray);
            }

            @Override
            protected void done() {
                super.done();
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        };
        swingWorker.execute();
        if (dialog != null && file2.length() > 50000000L) {
            dialog.setVisible(true);
        }
        return (Boolean)swingWorker.get();
    }

    static String getHashAlgorithm(byte[] byArray) {
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("La huella no puede ser nula ni vacia");
        }
        if (byArray.length == 20) {
            return "SHA-1";
        }
        return "SHA-" + Integer.toString(byArray.length * 8);
    }

    static boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        return CheckHashFileDialog.arrayEquals(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    private static boolean arrayEquals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4 || byArray.length < n + n2 || byArray2.length < n3 + n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i + n] == byArray2[i + n3]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 27 && !Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void launch(Window window) {
        CheckHashFileDialog checkHashFileDialog = new CheckHashFileDialog(window);
        checkHashFileDialog.setSize(600, 250);
        checkHashFileDialog.setResizable(false);
        checkHashFileDialog.setLocationRelativeTo(window);
        checkHashFileDialog.setVisible(true);
    }

    private static Image getDialogIcon() {
        Image image;
        try {
            image = UIFactory.getDefaultDialogIcon();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
            image = null;
        }
        return image;
    }
}

