/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.plugin.hash.CheckHashAction;
import es.gob.afirma.plugin.hash.CorruptedDocumentException;
import es.gob.afirma.plugin.hash.DocumentException;
import es.gob.afirma.plugin.hash.HashDocument;
import es.gob.afirma.plugin.hash.HashDocumentFactory;
import es.gob.afirma.plugin.hash.HashReport;
import es.gob.afirma.plugin.hash.HashUIHelper;
import es.gob.afirma.plugin.hash.HashUtil;
import es.gob.afirma.plugin.hash.Messages;
import es.gob.afirma.standalone.plugins.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CheckHashDirDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 5969239673119761747L;
    private static final Logger LOGGER = Logger.getLogger(CheckHashDirDialog.class.getName());
    private final JTextField reportTextField = new JTextField();
    private final JTextField directoryTextField = new JTextField();

    public static void startHashCheck(Window window) {
        CheckHashDirDialog checkHashDirDialog = new CheckHashDirDialog(window);
        checkHashDirDialog.setResizable(false);
        checkHashDirDialog.setSize(600, 250);
        checkHashDirDialog.setLocationRelativeTo(window);
        checkHashDirDialog.setVisible(true);
    }

    private CheckHashDirDialog(Window window) {
        super(window);
        this.setTitle(Messages.getString("CheckHashFiles.0"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.createUI(window);
    }

    void createUI(Component component) {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.setLocationRelativeTo(component);
        Image image = CheckHashDirDialog.getDialogIcon();
        this.setIconImage(image);
        this.setTitle(Messages.getString("CheckHashFiles.0"));
        JButton jButton = new JButton(Messages.getString("CheckHashDialog.1"));
        jButton.setMnemonic('R');
        jButton.setEnabled(false);
        jButton.addKeyListener(this);
        jButton.addActionListener(actionEvent -> {
            try {
                CheckResult checkResult;
                final JDialog jDialog = UIFactory.getWaitingDialog(null, (String)Messages.getString("CreateHashFiles.21"), (String)Messages.getString("CreateHashFiles.22"));
                SwingWorker<CheckResult, Void> swingWorker = new SwingWorker<CheckResult, Void>(){

                    @Override
                    protected CheckResult doInBackground() throws Exception {
                        HashReport hashReport = new HashReport();
                        try {
                            CheckHashDirDialog.checkHash(Paths.get(CheckHashDirDialog.this.getDirectorioText(), new String[0]), new File(CheckHashDirDialog.this.getReportPath()), hashReport);
                        }
                        catch (Exception exception) {
                            return new CheckResult(exception);
                        }
                        return new CheckResult(hashReport);
                    }

                    @Override
                    protected void done() {
                        super.done();
                        if (jDialog != null) {
                            jDialog.dispose();
                        }
                    }
                };
                swingWorker.execute();
                if (jDialog != null) {
                    jDialog.setVisible(true);
                }
                if ((checkResult = (CheckResult)swingWorker.get()).getException() != null) {
                    throw checkResult.getException();
                }
                HashReport hashReport = checkResult.getReport();
                if (!hashReport.hasErrors()) {
                    AOUIFactory.showMessageDialog((Object)this, (Object)Messages.getString("CheckHashDialog.2"), (String)Messages.getString("CheckHashDialog.3"), (int)1);
                } else {
                    AOUIFactory.showMessageDialog((Object)this, (Object)Messages.getString("CheckHashFiles.18"), (String)Messages.getString("CheckHashFiles.17"), (int)2);
                }
                byte[] byArray = CheckHashDirDialog.generateXMLReport(hashReport).getBytes(hashReport.getCharset());
                HashUIHelper.showSaveReportDialog(byArray, new File(this.getDirectorioText()).getParent(), component);
                jButton.setEnabled(false);
                this.setVisible(false);
                this.dispose();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                AOUIFactory.showErrorMessage((Object)Messages.getString("CreateHashFiles.2"), (String)Messages.getString("CreateHashDialog.14"), (int)0, (Throwable)outOfMemoryError);
                LOGGER.log(Level.SEVERE, "Fichero demasiado grande", outOfMemoryError);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
            }
            catch (DocumentException documentException) {
                LOGGER.log(Level.WARNING, "El documento seleccionado no es un documento de hashes soportado");
                AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashDialog.17"), (String)Messages.getString("CheckHashDialog.7"), (int)0, (Throwable)documentException);
            }
            catch (CorruptedDocumentException corruptedDocumentException) {
                LOGGER.log(Level.WARNING, "El documento seleccionado es un documento de hashes corrupto o manipulado", corruptedDocumentException);
                AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashDialog.18"), (String)Messages.getString("CheckHashDialog.7"), (int)0, (Throwable)corruptedDocumentException);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "No ha sido posible comprobar las huellas digitales", exception);
                AOUIFactory.showErrorMessage((Object)Messages.getString("CheckHashDialog.6"), (String)Messages.getString("CheckHashDialog.7"), (int)0, (Throwable)exception);
            }
        });
        jButton.setEnabled(false);
        this.reportTextField.setEditable(false);
        this.reportTextField.setFocusable(false);
        this.reportTextField.setColumns(10);
        this.reportTextField.addKeyListener(this);
        JButton jButton2 = new JButton(Messages.getString("CreateHashDialog.5"));
        jButton2.setMnemonic('E');
        jButton2.setEnabled(true);
        jButton2.addKeyListener(this);
        jButton2.addActionListener(actionEvent -> {
            try {
                this.setReportPath(AOUIFactory.getLoadFiles((String)Messages.getString("CreateHashDialog.5"), null, null, (String[])new String[]{"hashfiles", "txthashfiles"}, (String)Messages.getString("CheckHashFiles.19"), (boolean)false, (boolean)false, (Object)image, (Object)this)[0].getAbsolutePath());
                String string = this.getReportPath();
                if (string != null && !string.isEmpty()) {
                    jButton.setEnabled(true);
                }
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                // empty catch block
            }
        });
        this.directoryTextField.setEditable(false);
        this.directoryTextField.setFocusable(false);
        this.directoryTextField.setColumns(10);
        this.directoryTextField.addKeyListener(this);
        JButton jButton3 = new JButton(Messages.getString("CreateHashDialog.5"));
        jButton3.setMnemonic('X');
        jButton3.setEnabled(true);
        jButton3.addKeyListener(this);
        jButton3.addActionListener(actionEvent -> {
            try {
                this.setDirectoryPath(AOUIFactory.getLoadFiles((String)Messages.getString("CreateHashDialog.5"), null, null, null, (String)Messages.getString("CheckHashDialog.14"), (boolean)true, (boolean)false, (Object)image, (Object)this)[0].getAbsolutePath());
                String string = this.getReportPath();
                if (string != null && !string.isEmpty()) {
                    jButton.setEnabled(true);
                }
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                // empty catch block
            }
        });
        JButton jButton4 = new JButton(Messages.getString("CheckHashFiles.12"));
        if (!this.getReportPath().isEmpty() && !this.getDirectorioText().isEmpty()) {
            jButton.setEnabled(true);
        }
        jButton4.setMnemonic('C');
        jButton4.addKeyListener(this);
        jButton4.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        jButton4.getAccessibleContext().setAccessibleDescription(Messages.getString("CreateHashDialog.17"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            jPanel.add(jButton4);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton4);
        }
        JLabel jLabel = new JLabel(Messages.getString("CheckHashFiles.13"));
        jLabel.setLabelFor(this.directoryTextField);
        JLabel jLabel2 = new JLabel(Messages.getString("CheckHashFiles.14"));
        jLabel2.setLabelFor(this.reportTextField);
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add((Component)this.directoryTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        container.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        ++gridBagConstraints.gridy;
        container.add((Component)this.reportTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        container.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
    }

    static boolean checkFileHash(Path path, byte[] byArray, String string) throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        byte[] byArray2 = HashUtil.getFileHash(string, path);
        return Arrays.equals(byArray2, byArray);
    }

    public static void checkHash(Path path, File file, HashReport hashReport) throws IOException, DocumentException, CorruptedDocumentException {
        byte[] byArray = CheckHashDirDialog.loadData(file.getAbsolutePath());
        HashDocument hashDocument = HashDocumentFactory.loadDocument(byArray, CheckHashDirDialog.getExtension(file));
        hashReport.setAlgorithm(hashDocument.getAlgorithm());
        hashReport.setRecursive(hashDocument.isRecursive());
        long l = new Date().getTime();
        ForkJoinPool forkJoinPool = new ForkJoinPool(10);
        CheckHashAction checkHashAction = new CheckHashAction(path, path.toFile(), hashDocument, hashReport, forkJoinPool);
        forkJoinPool.invoke(checkHashAction);
        checkHashAction.join();
        long l2 = new Date().getTime() - l;
        LOGGER.info("Tiempo total de comprobacion de hashes: " + (double)l2 / 1000.0 + " seg");
        LOGGER.info("Numero de ficheros procesados: " + hashReport.getProcessedFilesCount());
        for (String string : hashDocument.getHashes().keySet()) {
            hashReport.reportHashWithoutFile(string);
        }
    }

    public static String generateXMLReport(HashReport hashReport) throws ParserConfigurationException, TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("entries");
        Attr attr = document.createAttribute("hashAlgorithm");
        attr.setValue(hashReport.getAlgorithm());
        element.setAttributeNode(attr);
        Attr attr2 = document.createAttribute("recursive");
        attr2.setValue(Boolean.toString(hashReport.isRecursive()));
        element.setAttributeNode(attr2);
        document.appendChild(element);
        Iterator<String> iterator = hashReport.getMatchingHashIterator();
        if (iterator.hasNext()) {
            object4 = document.createElement("matching_hash");
            while (iterator.hasNext()) {
                object4.appendChild(CheckHashDirDialog.createReportEntry(document, iterator.next()));
            }
            element.appendChild((Node)object4);
        }
        if ((object4 = hashReport.getNoMatchingHashIterator()).hasNext()) {
            object3 = document.createElement("not_matching_hash");
            while (object4.hasNext()) {
                object3.appendChild(CheckHashDirDialog.createReportEntry(document, (String)object4.next()));
            }
            element.appendChild((Node)object3);
        }
        if ((object3 = hashReport.getHashWithoutFileIterator()).hasNext()) {
            object2 = document.createElement("hash_without_file");
            while (object3.hasNext()) {
                object2.appendChild(CheckHashDirDialog.createReportEntry(document, (String)object3.next()));
            }
            element.appendChild((Node)object2);
        }
        if ((object2 = hashReport.getFileWithoutHashIterator()).hasNext()) {
            object = document.createElement("file_without_hash");
            while (object2.hasNext()) {
                object.appendChild(CheckHashDirDialog.createReportEntry(document, (String)object2.next()));
            }
            element.appendChild((Node)object);
        }
        object = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(new DOMSource(document), new StreamResult((Writer)object));
        return ((StringWriter)object).toString();
    }

    private static Element createReportEntry(Document document, String string) {
        Element element = document.createElement("entry");
        Attr attr = document.createAttribute("name");
        attr.setValue(string);
        element.setAttributeNode(attr);
        return element;
    }

    String getReportPath() {
        return this.reportTextField.getText();
    }

    void setReportPath(String string) {
        this.reportTextField.setText(string);
    }

    String getDirectorioText() {
        return this.directoryTextField.getText();
    }

    void setDirectoryPath(String string) {
        this.directoryTextField.setText(string);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 27 && !Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static byte[] loadData(String string) throws IOException {
        URI uRI;
        try {
            uRI = AOUtil.createURI((String)string);
        }
        catch (Exception exception) {
            throw new IOException("No se pudo componer la ruta del fichero", exception);
        }
        return AOUtil.getDataFromInputStream((InputStream)AOUtil.loadFile((URI)uRI));
    }

    private static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n == -1 || n == string.length() - 1 ? null : string.substring(n + 1);
    }

    private static Image getDialogIcon() {
        Image image;
        try {
            image = UIFactory.getDefaultDialogIcon();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido cargar el icono del dialogo: " + exception);
            image = null;
        }
        return image;
    }

    class CheckResult {
        private final Exception exception;
        private final HashReport report;

        public CheckResult(HashReport hashReport) {
            this.report = hashReport;
            this.exception = null;
        }

        public CheckResult(Exception exception) {
            this.report = null;
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public HashReport getReport() {
            return this.report;
        }
    }
}

