/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.plugin.hash;

import es.gob.afirma.plugin.hash.HashDocument;
import es.gob.afirma.plugin.hash.HashReport;
import es.gob.afirma.plugin.hash.HashUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckHashAction
extends RecursiveAction {
    private static final long serialVersionUID = 9133180415134836622L;
    private static final Set<String> FILES_TO_AVOID = new HashSet<String>(Arrays.asList(".fseventsd", ".Spotlight-V100", ".Trashes", "._.Trashes", ".DS_Store", ".desktop", "thumbs.db", "$Recycle.Bin"));
    private static final Logger LOGGER = Logger.getLogger(CheckHashAction.class.getName());
    private final Path basePath;
    private final File dataFile;
    private final boolean recursive;
    private final String digestAlgorithm;
    private final Map<String, byte[]> hashes;
    private final HashReport report;
    private final ForkJoinPool pool;

    public CheckHashAction(Path path, File file, HashDocument hashDocument, HashReport hashReport, ForkJoinPool forkJoinPool) {
        this.basePath = path;
        this.dataFile = file;
        this.recursive = hashDocument.isRecursive();
        this.digestAlgorithm = hashDocument.getAlgorithm();
        this.hashes = hashDocument.getHashes();
        this.report = hashReport;
        this.pool = forkJoinPool;
    }

    public CheckHashAction(Path path, File file, boolean bl, String string, Map<String, byte[]> map, HashReport hashReport, ForkJoinPool forkJoinPool) {
        this.basePath = path;
        this.dataFile = file;
        this.recursive = bl;
        this.digestAlgorithm = string;
        this.hashes = map;
        this.report = hashReport;
        this.pool = forkJoinPool;
    }

    @Override
    protected void compute() {
        if (this.dataFile.isFile()) {
            if (!this.dataFile.getName().contains("~$") && !FILES_TO_AVOID.contains(this.dataFile.getName())) {
                this.processing();
            }
        } else {
            ArrayList<CheckHashAction> arrayList = new ArrayList<CheckHashAction>();
            for (File file : this.dataFile.listFiles()) {
                if (!this.recursive && !file.isFile()) continue;
                arrayList.add(new CheckHashAction(this.basePath, file, this.recursive, this.digestAlgorithm, this.hashes, this.report, this.pool));
            }
            if (!this.pool.isShutdown()) {
                ForkJoinTask.invokeAll(arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processing() {
        String string = this.basePath.relativize(Paths.get(this.dataFile.getAbsolutePath(), new String[0])).toString();
        byte[] byArray = this.hashes.get(string);
        if (byArray == null) {
            this.report.reportFileWithoutHash(string);
        } else {
            byte[] byArray2;
            try {
                byArray2 = HashUtil.getFileHash(this.digestAlgorithm, this.dataFile);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.log(Level.SEVERE, "Se ha indicado un algoritmo de hash no soportado", noSuchAlgorithmException);
                this.pool.shutdown();
                return;
            }
            catch (Error | Exception throwable) {
                LOGGER.log(Level.SEVERE, "Error al calcular el hash de un fichero", throwable);
                this.pool.shutdown();
                return;
            }
            if (Arrays.equals(byArray, byArray2)) {
                this.report.reportMatchingHash(string);
            } else {
                this.report.reportNoMatchingHash(string);
            }
            Map<String, byte[]> map = this.hashes;
            synchronized (map) {
                this.hashes.remove(string);
            }
        }
    }
}

